<?php
/* --------------------------------------------------------------
   UserConfigurationWriter.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration\Repository;

use Doctrine\DBAL\Connection;
use Gambio\Admin\UserConfiguration\Interfaces\UserConfiguration;
use Gambio\Admin\UserConfiguration\Interfaces\UserConfigurationKey;
use Gambio\Admin\UserConfiguration\Interfaces\UserId;

/**
 * Class UserConfigurationWriter
 *
 * @package Gambio\Admin\UserConfiguration\Repository
 */
class UserConfigurationWriter
{
    /**
     * @var Connection
     */
    private $db;
    
    
    /**
     * UserConfigurationWriter constructor.
     *
     * @param Connection $db
     */
    public function __construct(Connection $db)
    {
        $this->db = $db;
    }
    
    
    /**
     * @param UserId            $userId
     * @param UserConfiguration $configuration
     */
    public function store(UserId $userId, UserConfiguration $configuration): void
    {
        $this->db->executeQuery('REPLACE INTO `user_configuration` (`customer_id`, `configuration_key`, `configuration_value`) VALUES  (:userId, :key, :value);',
                                [
                                    'userId' => $userId->userId(),
                                    'key'    => $configuration->key(),
                                    'value'  => $configuration->value(),
                                ]);
    }
    
    
    /**
     * @param UserId               $userId
     * @param UserConfigurationKey $key
     */
    public function delete(UserId $userId, UserConfigurationKey $key): void
    {
        $this->db->createQueryBuilder()
            ->delete('user_configuration')
            ->where('customer_id = :userId AND configuration_key = :key')
            ->setParameter('userId', $userId->userId())
            ->setParameter('key', $key->value())
            ->execute();
    }
}